SELECT wt.wait_duration_ms AS duree_attente_ms,
       wt.wait_type AS type_attente,
       s.text AS requete,
       p.query_plan AS plan_requete,
       wt.session_id,
       DB_NAME(er.database_id) AS nom_base,
       er.wait_resource,
       er.command,
       er.last_wait_type
FROM   sys.dm_os_waiting_tasks AS wt
       INNER JOIN sys.dm_exec_requests AS er
             ON wt.session_id = er.session_id
       INNER JOIN sys.dm_exec_sessions es
             ON es.session_id = er.session_id
       CROSS APPLY sys.dm_exec_sql_text (er.sql_handle) AS s
       CROSS APPLY sys.dm_exec_query_plan (er.plan_handle) AS p
WHERE  es.is_user_process = 1;

--> NOTA : cette requte est lgrement diffrente de celle prsente dans la version imprime. En effet, nous avons retir l'accent circonflexe prsent par deux fois dans les alias de nom de colonne.